% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpInitGene.R
\name{xegaGpInitGeneGe}
\alias{xegaGpInitGeneGe}
\title{Generates a gene as a random derivation tree from a random integer vector.}
\usage{
xegaGpInitGeneGe(lF)
}
\arguments{
\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
Derivation tree.
}
\description{
For a given grammar, \code{xegaGpInitGene()} 
             generates a gene as a random derivation tree
             with a depth-bound. This function uses almost the same 
             initialization algorithm as for grammatical evolution.
}
\details{
In the derivation tree representation of 
         package \code{xegaGpGene}, a \emph{gene} is a list with 
         \enumerate{
         \item \code{$gene1}:     a derivation tree.
         \item \code{$fit}:       The fitness of the genotype of 
                                 \code{$gene1}         
         \item \code{$evaluated}: Boolean: TRUE if the fitness is known.
         \item \code{$evalFail}:   Has the evaluation of the gene failed?
   \item \code{$var}:        The cumulative variance of the fitness 
                     of all evaluations of a gene.
                     (For stochastic functions)
   \item \code{$sigma}:      The standard deviation of the fitness of 
                     all evaluations of a gene.
                     (For stochastic functions)
   \item \code{$obs}:        The number of evaluations of a gene.
                     (For stochastic functions)
         }

         The algorithm for generating a complete derivation tree 
         with a depth-bound
         is imported from the package \code{xegaDerivationTrees}.
}
\examples{
gene<-xegaGpInitGeneGe(lFxegaGpGene)
xegaGpDecodeGene(gene, lFxegaGpGene)

}
\seealso{
Other Gene Generation: 
\code{\link{xegaGpInitGene}()}
}
\concept{Gene Generation}
