% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGplF.R
\docType{data}
\name{lFxegaGpGene}
\alias{lFxegaGpGene}
\title{Generate local functions and objects.}
\format{
An object of class \code{list} of length 25.
}
\usage{
lFxegaGpGene
}
\description{
We enhance the configurability of our code by introducing 
 a function factory. The  function factory contains
 all the functions that are needed for defining
 local functions in genetic operators. The local function  
 list keeps the signatures of functions (e.g. mutation functions)
 uniform and small. At the same time, variants of functions
 can use different local functions.
}
\details{
We use the local function list for 
   \enumerate{
   \item
      replacing all constants by constant functions.
      
      Rationale: We need one formal argument (the local function list lF)
      and we can dispatch multiple functions. E.g.  \code{lF$verbose()}
  \item    
      dynamically binding a local function with a definition from a
      proper function factory. E.g., the selection methods 
      \code{lF$SelectGene()} and \code{lF$SelectMate()}.
      
 \item gene representations which require special functions to handle them:
       For example,
       \code{lF$InitGene()}, \code{lF$DecodeGene()}, \code{lF$EvalGene()},
       \code{lF$ReplicateGene()}, ...
      
 }
}
\keyword{datasets}
