% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_coefficients.R
\name{.CalculateGaussCoef}
\alias{.CalculateGaussCoef}
\title{Lookup Table for Gauss coefficients g & h}
\usage{
.CalculateGaussCoef(t, t0, wmmVersion = "derived")
}
\arguments{
\item{t}{Annualized date time. E.g., 2015-02-01 = (2015 + 32/365) = 2015.088}

\item{t0}{Annualized reference time associated with \code{t}}

\item{wmmVersion}{String representing WMM version to use. Must be consistent with \code{time} and one of the following: 'derived', 'WMM2000', 'WMM2005', 'WMM2010', 'WMM2015', 'WMM2015v2', 'WMM2020'. Default 'derived' value will infer the latest WMM version consistent with \code{time}.}
}
\value{
vector of Gauss coefficients, \eqn{g_{n,m}(t)} and \eqn{h_{n,m}(t)}
}
\description{
Find Gauss coefficient \eqn{g_{n,m}(t)} consistent with the World Magnetic Model.
}
