% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{parse_MaxQuant}
\alias{parse_MaxQuant}
\title{Converting MaxQuant Output file proteinGroups.txt to CLARION format
by creating a headline of metadata for each column}
\usage{
parse_MaxQuant(
  proteinGroups_in,
  summary_in,
  outfile,
  outfile_reduced,
  config = system.file("extdata", "parser_MaxQuant_config.json", package = "wilson"),
  delimiter = ";",
  format = NULL,
  version = NULL,
  experiment_id = NULL
)
}
\arguments{
\item{proteinGroups_in}{path of proteinGroup.txt file}

\item{summary_in}{path of belonging summary.txt file}

\item{outfile}{path of full CLARION output file}

\item{outfile_reduced}{path of reduced CLARION output file}

\item{config}{path of config file (containing information about metadata)}

\item{delimiter}{delimiter (Default = ;)}

\item{format}{pre-header information about format (optional)}

\item{version}{pre-header information about version (optional)}

\item{experiment_id}{pre-header information about experiment id (optional)}
}
\value{
TRUE on success
}
\description{
List with columns of reduced version (see config.json file)
If you only want the samples of a specific keyword write: column;exp
For example:
  You got:
      Intensity
      Intensity 'experiment_name'
Do you want both add "Intensity" to the list.
Do you only want the sample add "Intensity;exp" to the list
Anything else like 'Intensity;ex' or 'Intensity;' results in writing both.
Only works if there are samples of that type. If not, column does not show up in file
}
\author{
Rene Wiegandt
}
