% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{create_scatterplot}
\alias{create_scatterplot}
\title{Method for scatter plot creation}
\usage{
create_scatterplot(
  data,
  data.labels = NULL,
  data.hovertext = NULL,
  transparency = 1,
  pointsize = 1,
  labelsize = 3,
  color = NULL,
  x_label = "",
  y_label = "",
  z_label = "",
  density = TRUE,
  line = TRUE,
  categorized = FALSE,
  highlight.data = NULL,
  highlight.labels = NULL,
  highlight.hovertext = NULL,
  highlight.color = "#FF0000",
  xlim = NULL,
  ylim = NULL,
  colorbar.limits = NULL,
  width = "auto",
  height = "auto",
  ppi = 72,
  plot.method = "static",
  scale = 1
)
}
\arguments{
\item{data}{data.table containing plot data
column 1: id
column 2, 3(, 4): x, y(, z)}

\item{data.labels}{Vector of labels used for data. Length has to be equal to nrow(data).}

\item{data.hovertext}{Character vector with additional hovertext. Length has to be equal to nrow(data).}

\item{transparency}{Set point transparency. See \code{\link[ggplot2]{geom_point}}.}

\item{pointsize}{Set point size. See \code{\link[ggplot2]{geom_point}}.}

\item{labelsize}{Set label size. See \code{\link[ggplot2]{geom_text}}.}

\item{color}{Vector of colors used for color palette.}

\item{x_label}{Label x-Axis}

\item{y_label}{Label Y-Axis}

\item{z_label}{Label Z-Axis}

\item{density}{Boolean value, perform 2d density estimate.}

\item{line}{Boolean value, add reference line.}

\item{categorized}{Z-Axis (if exists) as categories.}

\item{highlight.data}{data.table containing data to highlight. Same structure as data.}

\item{highlight.labels}{Vector of labels used for highlighted data. Length has to be equal to nrow(highlight.data).}

\item{highlight.hovertext}{Character vector with additional hovertext. Length has to be equal to nrow(highlight.data).}

\item{highlight.color}{String with hexadecimal color-code.}

\item{xlim}{Numeric vector of two setting min and max limit of x-axis. See \code{\link[ggplot2]{lims}}.}

\item{ylim}{Numeric vector of two setting min and max limit of y-axis. See \code{\link[ggplot2]{lims}}.}

\item{colorbar.limits}{Vector with min, max values for colorbar (Default = NULL).}

\item{width}{Set plot width in cm (Default = "auto").}

\item{height}{Set plot height in cm (Default = "auto").}

\item{ppi}{Pixel per inch (default = 72).}

\item{plot.method}{Whether the plot should be 'interactive' or 'static' (Default = 'static').}

\item{scale}{Modify plot size while preserving aspect ratio (Default = 1).}
}
\value{
Returns list(plot = ggplotly/ ggplot, width, height, ppi, exceed_size).
}
\description{
Method for scatter plot creation
}
\details{
Width/ height limit = 500. If exceeded default to 500 and issue exceed_size = TRUE.
}
