% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{doChunks}
\alias{doChunks}
\title{Execute a function in chunks.}
\usage{
doChunks(f, x, chunksize, ...)
}
\arguments{
\item{f}{The function to execute.}

\item{x}{Vector of entities or titles/pageids.}

\item{chunksize}{The number of elements in \code{x} to execute the function.}

\item{...}{The \code{f} arguments.}
}
\value{
The results of execute \code{f} using all values of \code{x}
}
\description{
Execute the function f(x,...) in chunks of chunk-size elements each.
Wikidata and Wikimedia API have limits to execute a query. Wikidata has
timeout limits, Wikimedia about the number of titles or pageIds. This function
executes sequentially the function \code{f} over chunks of elements to prevent
errors.
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
