% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_checkrow.R
\name{helper_checkrow}
\alias{helper_checkrow}
\title{Check a vector for particular values}
\usage{
helper_checkrow(
  row,
  check_type = c("all_equal", "all_not_equal", "any_in"),
  check_value,
  na_rm = TRUE
)
}
\arguments{
\item{row}{a vector of data}

\item{check_type}{a string indicating the type of check to do on \code{row}. Options are \code{"all_equal"}, \code{"all_not_equal"}, and \code{"any_in"}. A value of \code{"all_equal"} will check that all values in \code{row} equal \code{check_value}. A value of \code{"all_not_equal"} will check that all values of \code{row} are not equal to \code{check_value}. A value of \code{"any_in"} will check if any of the values in \code{check_value} are in \code{row}.}

\item{check_value}{a vector of values to check against}

\item{na_rm}{logical indicating whether or not to perform check after removing NAs, passed to argument \code{na.rm} of \code{any()} or \code{all()}. Default is TRUE.}
}
\value{
a logical vector with the result of the check
}
\description{
Check a vector for particular values
}
\details{
If all values of \code{row} are NA, then an NA is returned.
}
\seealso{
Other helper functions: 
\code{\link{helper_palette}()},
\code{\link{helper_varslist}()}
}
\concept{helper functions}
