% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_outliers.R
\name{identify_outliers}
\alias{identify_outliers}
\title{Identify Outliers in a Data Frame Column}
\usage{
identify_outliers(df, var)
}
\arguments{
\item{df}{The data frame.}

\item{var}{The column to check for outliers.}
}
\value{
A tibble containing the unique values, tally, and whether each value is an outlier or not.
}
\description{
This function identifies outliers in a specified column of a data frame.
It returns a tibble containing the unique values, tally, and whether it is an outlier or not.
}
\examples{
df <- data.frame(a = c(1, 2, 3, 100, 101), b = c(4, 5, 6, 7, 8), c = c(7, 8, 9, 100, 101))
outliers <- identify_outliers(df, "a")
print(outliers)

}
