% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_assertions_message.R
\name{check_na_columns}
\alias{check_na_columns}
\title{Check for columns with only NA values}
\usage{
check_na_columns(df, collection)
}
\arguments{
\item{df}{A dataframe.}

\item{collection}{A list to store the names of the columns with only NA values.}
}
\value{
The updated collection.
}
\description{
This function checks if there are any columns in the provided dataframe that contain only NA values.
If such columns exist, their names are added to the provided collection.
}
\examples{
# Create a dataframe with some columns containing only NA values
df <- data.frame(a = c(1, NA, 3), b = c(NA, NA, NA), c = c(4, 5, 6))
collection <- checkmate::makeAssertCollection()
check_na_columns(df, collection)
}
