% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_find.R
\name{vascr_find}
\alias{vascr_find}
\title{Find vascr variables}
\usage{
vascr_find(data.df = vascr::growth.df, paramater, value = NA)
}
\arguments{
\item{data.df}{The vascr dataset to reference, will default to the growth.df dataset if not specified}

\item{paramater}{The parameter to search. Options are "Time", "Unit", "Well", "Frequency", "Sample", "Experiment", "SampleID" or "resampled"}

\item{value}{the value to look up}
}
\value{
The valid vascr dataset.
}
\description{
These functions are utility functions that will detect if arguments are invalid, 
and attempt to repair them. Each type of variable has rules related to what values
are possible in a valid vascr dataset.
}
\examples{

vascr_find(growth.df, "Time")
vascr_find(growth.df, "Time", 66.97)
vascr_find(growth.df, "Time", NULL)

vascr_find(growth.df, "Unit")
vascr_find(growth.df, "Unit", "Rb")
vascr_find(growth.df, "Unit", NULL)

vascr_find(growth.df, "Well")
vascr_find(growth.df, "Well", "A1")

vascr_find(growth.df, "Sample")
vascr_find(growth.df, "Sample", "5000 cells")

vascr_find(growth.df, "Frequency")
vascr_find(growth.df, "Frequency", 4000)

vascr_find(growth.df, "Experiment")
vascr_find(growth.df, "Experiment", 1)

vascr_find(growth.df, "SampleID")
vascr_find(growth.df, "SampleID", 5)

vascr_find(growth.df, "resampled")

vascr_find(growth.df, "all")
}
