% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{get_forcedecks_data}
\alias{get_forcedecks_data}
\title{Run full initial data fetch from the VALD ForceDecks API and External Profiles API}
\usage{
get_forcedecks_data(start_date = NULL)
}
\arguments{
\item{start_date}{In ISO 8601 UTC format (e.g., "2025-06-25T00:00:00Z") indicating the start of the test retrieval window.}
}
\value{
A named list with data frames: \code{profiles}, \code{result_definitions}, \code{tests}, and \code{trials}.
Each element contains the respective dataset fetched from the ForceDecks API.
}
\description{
This function is intended for first-time use or a full refresh of all datasets.
It retrieves profiles, result definitions, tests (from a specified start date), and trials.
}
\examples{
\dontrun{
# Fetch all data (profiles, results, tests, trials)
data <- get_forcedecks_data()
View(data$profiles)
}
}
