% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auckland.R
\docType{data}
\name{auckland_1}
\alias{auckland_1}
\title{University web colours of the University of Auckland, NZ}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on Version 12 of the \href{https://www.auckland.ac.nz/en.html}{University of Auckland}'s 
\href{https://cdn.auckland.ac.nz/assets/central/about/the-university/how-the-university-works/policy-and-administration/web-style-guide.pdf}{Web Style Guide (PDF)}.
}
\usage{
auckland_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{auckland_1} provides the university web colour range 
of the \href{https://www.auckland.ac.nz/en.html}{University of Auckland}, New Zealand.
}
\details{
The University web colours are used for all areas of the 
central and service division website.

A faculty is able to choose between using the 
University web colour range or their specific faculty style 
(see \code{\link{auckland_2}}).
}
\examples{
auckland_1
unikn::seecol(auckland_1, main = "Web colour range of the University of Auckland, NZ")

}
\seealso{
\code{\link{auckland_2}} for faculty colours of the University of Auckland;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other New Zealand university color palettes: 
\code{\link{auckland_2}},
\code{\link{otago}},
\code{\link{waikato}}
}
\author{
\strong{unicol}, 2023-09-07.
}
\concept{New Zealand university color palettes}
\keyword{datasets}
