% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_exercise.R
\name{make_exercise}
\alias{make_exercise}
\title{Add a tutorial code exercise or question to the active document}
\usage{
make_exercise(type = "no-answer", file_path = NULL)
}
\arguments{
\item{type}{Character of question type. Must be one of "code", "no-answer",
or "yes-answer". Abbreviations such as "no", "yes", and "co" are allowed.}

\item{file_path}{Character path to a file. If NULL, the RStudio active
document is used, which is the default behavior. An actual file path is
used for testing.}
}
\value{
Exercise skeleton corresponding to the \code{type} argument.
}
\description{
When writing tutorials, it is handy to be able to insert the
skeleton for a new code exercise or question. Note that the
function determines the correct exercise number to use and also adds
appropriate code chunk labels, based on the exercise number and section
title.
}
