% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_diff.R
\name{ts_norm_diff}
\alias{ts_norm_diff}
\title{First Differences}
\usage{
ts_norm_diff(outliers = outliers_boxplot())
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}
}
\value{
A \code{ts_norm_diff} object.
}
\description{
Transform a series by first differences to remove level and
highlight changes; normalization is then applied to the differenced series.
}
\examples{
# Differencing + global min–max normalization
# Load package and example data
library(daltoolbox)
data(tsd)

# Convert to sliding windows and preview raw last column
ts <- ts_data(tsd$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# Fit differencing preprocessor and transform; note one fewer lag column
preproc <- ts_norm_diff()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,9])
}
\references{
Salles, R., Assis, L., Guedes, G., Bezerra, E., Porto, F., Ogasawara, E.
(2017). A framework for benchmarking machine learning methods using linear
models for univariate time series prediction. Proceedings of the
International Joint Conference on Neural Networks (IJCNN).
doi:10.1109/IJCNN.2017.7966139
}
