% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_recursive.R
\name{ts_fil_recursive}
\alias{ts_fil_recursive}
\title{Recursive Filter}
\usage{
ts_fil_recursive(filter)
}
\arguments{
\item{filter}{smoothing parameter. The larger the value, the greater the smoothing. The smaller the value, the less smoothing, and the resulting series shape is more similar to the original series.}
}
\value{
A \code{ts_fil_recursive} object.
}
\description{
Apply recursive linear filtering (ARMA-style recursion) to a
univariate series or each column of a multivariate series. Useful for
smoothing and mitigating autocorrelation.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_recursive(filter =  0.05)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
