% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_logging_package.R
\name{set.logging.package}
\alias{set.logging.package}
\title{Enables one of the supported logging package used by tryCatchLog to write log output}
\usage{
set.logging.package(
  logging.package.name = getOption("tryCatchLog.preferred.logging.package",
    c("futile.logger", "lgr", "tryCatchLog"))
)
}
\arguments{
\item{logging.package.name}{The name of the logging package (character) that shall be enabled.}
}
\value{
The name of the enabled logging framework
}
\description{
If this optional argument is omitted, either the package name
from the option \code{tryCatchLog.preferred.logging.package} is enabled
or all supported logging packages (see the vector of default values) are probed in this order
and the first existing (= installed) logging package is enabled.
}
\details{
If the passed logging framework(s) is/are not installed the internal logging functions of
\code{tryCatchLog} will be enabled as fall-back.

To enable a non-supported logging framework you can call \code{\link{set.logging.functions}} instead.

To configure a standard logging package when \code{tryCatchLog} is loaded and \code{set.logging.package}
is called without an argument
you can use the option \code{tryCatchLog.preferred.logging.package}.
You could also set a vector of packages to "probe" (the first installed package of the list is taken,
in none is installed \code{tryCatchLog}-internal logging is used.
}
\examples{
tryCatchLog:::set.logging.package("futile.logger")
tryCatchLog:::set.logging.package("lgr")
tryCatchLog:::set.logging.package("tryCatchLog")

# takes the first installed logging package from the list of supported packages
tryCatchLog:::set.logging.package()

# only considered when tryCatchLog is loaded or set.logging.package() is called!
# takes the logging package fromt the configured option (if installed, else tryCatchLog)
options(tryCatchLog.preferred.logging.package = "futile.logger")
tryCatchLog:::set.logging.package()
}
\seealso{
\code{\link{set.logging.functions}}
}
