% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truelies-package.R
\docType{package}
\name{truelies-package}
\alias{truelies}
\alias{truelies-package}
\title{truelies: Bayesian Methods to Estimate the Proportion of Liars in
    Coin Flip Experiments}
\description{
Implements Bayesian methods, described in
    Hugh-Jones (2019) <doi:10.1007/s40881-019-00069-x>, for estimating the
    proportion of liars in coin flip-style experiments, where subjects
    report a random outcome and are paid for reporting a "good" outcome.
}
\section{Usage}{


To estimate the proportion of liars in an experiment, use \code{\link[=update_prior]{update_prior()}}
followed by \code{\link[=dist_mean]{dist_mean()}}:\preformatted{posterior <- update_prior(heads = 33, N = 50, P = 0.5, prior = dunif)
dist_mean(posterior)
}

To get confidence intervals for an estimate, use \code{\link[=dist_hdr]{dist_hdr()}}:\preformatted{dist_hdr(posterior, conf_level = 0.95)
}

To test whether two different samples have the same proportion of
liars, use \code{\link[=difference_dist]{difference_dist()}} followed by \code{\link[=dist_hdr]{dist_hdr()}}:\preformatted{p2 <- update_prior(heads = 42, N = 49, P = 0.5, prior = dunif)
dd <- difference_dist(posterior, p2)
dist_hdr(dd, 0.95, bounds = c(-1, 1))
}

To test power for detecting a given proportion of liars, use \code{\link[=power_calc]{power_calc()}}:\preformatted{power_calc(N = 100, P = 0.5, lambda = 0.2)
}

To test power for detecting differences between groups, use \code{\link[=power_calc_difference]{power_calc_difference()}}:\preformatted{power_calc_difference(N1 = 100, P = 5/6, lambda1 = 0.1, lambda2 = 0.25)
}

To compare different samples by empirical Bayes estimation, use
\code{\link[=empirical_bayes]{empirical_bayes()}}:\preformatted{heads <- c(Baseline = 30, Treatment1 = 38, Treatment2 = 45)
N <- c(50, 52, 57)
result <- empirical_bayes(heads, N, P = 0.5)
}
}

\section{Testing the package}{


To run tests on the package:\preformatted{source(system.file("test-statistics.R", package = "truelies"))
}

You will need \pkg{dplyr}, \pkg{purrr}, \pkg{tidyr} and \pkg{ggplot2} installed.

This will take some time and will produce data frames of test results
for different parameter values, along with some plots.
}

\references{
Hugh-Jones, David (2019). True Lies: Comment on Garbarino,
Slonim and Villeval (2018). Journal of the Economic Science Association.
https://link.springer.com/article/10.1007/s40881-019-00069-x.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/hughjonesd/truelies}
  \item Report bugs at \url{https://github.com/hughjonesd/truelies/issues}
}

}
\author{
David Hugh-Jones
}
\keyword{internal}
