% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{compare_dists}
\alias{compare_dists}
\title{Calculate probability that one posterior is larger than another}
\usage{
compare_dists(dist1, dist2)
}
\arguments{
\item{dist1}{Density of distribution 1, as a one-argument function.}

\item{dist2}{Density of distribution 2.}
}
\value{
A probability scalar.
}
\description{
Given two distributions with density functions \eqn{\phi_1, \phi_2},
this calculates:

\deqn{
\int_0^1 \int_0^{l_1}\phi_1(l_1) \phi_2(l_2) d l_2 d l_1,
}
the probability that the value of the first distribution is greater.
}
\examples{

d1 <- update_prior(30, 50, P = 0.5, prior = stats::dunif)
d2 <- update_prior(25, 40, P = 0.5, prior = stats::dunif)
compare_dists(d1, d2)

}
