% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{explore_poisson_trend_Legacy}
\alias{explore_poisson_trend_Legacy}
\title{(Legacy) Old version of explore_poisson_trend()}
\usage{
explore_poisson_trend_Legacy(
  data,
  datum_col,
  value_col,
  group_col = NULL,
  df_spline = 4,
  family = c("auto", "poisson", "negbin"),
  phi_threshold = 1.5,
  return_formula = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame with time series count data. / Data Frame mit Zeitreihen-Zaehldaten.}

\item{datum_col}{Name of the time column (usually Date). / Name der Zeit-Spalte (normalerweise Date).}

\item{value_col}{Name of the count column (dependent variable). / Name der Zaehldaten-Spalte (abhaengige Variable).}

\item{group_col}{Optional. Name of grouping column for interaction. / Optional. Name der Gruppierungs-Spalte fuer Interaktion.}

\item{family}{Specifies the GAM family: "auto" (default, chooses based on overdispersion), "poisson", or "negbin". /
Gibt die GAM-Familie an: "auto" (Standard, Auswahl basierend auf Overdispersion), "poisson" oder "negbin".}

\item{return_formula}{If TRUE, returns the model formula instead of fitting. / Wenn TRUE, wird die Modellformel zurueckgegeben.}

\item{verbose}{Logical. Whether to print model fitting messages. / Ob Modellanpassungsmeldungen ausgegeben werden sollen.}
}
\value{
A list containing: / Eine Liste mit:
\describe{
  \item{model}{Fitted GAM model object / Angepasstes GAM-Modellobjekt}
  \item{summary}{Summary of the model / Modellzusammenfassung}
  \item{plot}{ggplot of observed vs fitted trend / ggplot mit beobachteten und geschaetzten Trends}
  \item{dispersion_parameter}{List with overdispersion info (phi or theta) / Liste mit Overdispersion-Informationen (phi oder theta)}
  \item{model_family_used}{Model family used / Verwendete Modellfamilie}
  \item{model_selection_info}{Explanation of model selection / Beschreibung der Modellauswahl}
  \item{effective_df}{Effective degrees of freedom of smooth term(s) / Effektive Freiheitsgrade der glatten Terme}
  \item{aic_comparison}{AIC comparison if applicable / AIC-Vergleich, falls zutreffend}
  \item{messages}{Vector of fitting messages and warnings / Meldungen und Warnungen zur Modellanpassung}
  \item{formula}{Model formula used / Verwendete Modellformel}
}
}
\description{
Legacy function retained for compatibility.
This is the previous version of \code{\link{explore_poisson_trend}} prior to the GAM extension and diagnostics update.

Alte Version der Funktion \code{\link{explore_poisson_trend}}, nur aus Kompatibilitaetsgruenden behalten.
}
\examples{
# Simulierte Zeitreihen-Zaehldaten
set.seed(123)
df <- data.frame(
  datum = seq.Date(from = as.Date("2023-01-01"), by = "day", length.out = 100),
  value = rpois(100, lambda = 5)
)

# Automatische Familienauswahl basierend auf Overdispersion
explore_poisson_trend(df, datum_col = "datum", value_col = "value", family = "auto")

# Negative Binomial-GAM erzwingen
explore_poisson_trend(df, datum_col = "datum", value_col = "value", family = "negbin")

}
\seealso{
[mgcv::gam()], [mgcv::nb()], [explore_zinb_trend()]
}
\keyword{internal}
