################################################################################
# Returns the variance-covariance matrix from, e.g, vcov(lm.obj) to conform
# to the variance-covariance matrix order from tostregress in Stata. That is, it
# renames '(Intercept)' as '_cons', and moves _cons to the last row & column.
# Author: Alexis Dinno
# Date: Oct 21, 2025
# Takes: A linear model object
stata_vcm <- function(x) {
  r_vcm <- vcov(x)
  n <- length(r_vcm[1,])
  out <- r_vcm
  out[1:(n-1),1:(n-1)] <- r_vcm[2:n,2:n]
  out[n,] <- c(r_vcm[2:n,1],r_vcm[1,1])
  out[,n] <- c(r_vcm[2:n,1],r_vcm[1,1])
  s_vcm_names <- gsub(".*\\$","",c(row.names(r_vcm)[2:n], "_cons"))
  row.names(out) <- s_vcm_names
  colnames(out) <- s_vcm_names
  return(out)
  }