% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_validate.R
\name{validate_toon}
\alias{validate_toon}
\title{Validate TOON}
\usage{
validate_toon(
  x,
  is_file = FALSE,
  strict = TRUE,
  allow_comments = TRUE,
  allow_duplicate_keys = TRUE
)
}
\arguments{
\item{x}{Character scalar containing TOON text, or file path if is_file=TRUE.}

\item{is_file}{Logical. If TRUE, x is treated as a file path.}

\item{strict}{Logical. If TRUE (default), enforce strict TOON syntax.}

\item{allow_comments}{Logical. If TRUE (default), allow # and // comments.}

\item{allow_duplicate_keys}{Logical. If TRUE (default), allow duplicate keys.}
}
\value{
Logical scalar.
\itemize{
\item TRUE if valid.
\item FALSE if invalid, with attribute \code{attr(result, "error")}
containing a structured error object with components: type, message,
line, column, snippet, file.
}
}
\description{
Validate TOON
}
\details{
Never throws unless there's an internal error (e.g., file unreadable).
May warn for permissive recoveries.
}
\examples{
# Valid TOON
validate_toon('key: "value"')

# Invalid TOON (returns FALSE with error attribute)
result <- validate_toon('key: {invalid')
if (!result) print(attr(result, "error")$message)

}
