% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tomledit.R
\name{toml}
\alias{toml}
\alias{read_toml}
\alias{parse_toml}
\alias{write_toml}
\alias{edit_toml}
\title{Parse or Edit TOML text}
\usage{
read_toml(file, as_json = FALSE)

parse_toml(toml, as_json = FALSE)

write_toml(x, auto_unbox = TRUE)

edit_toml(toml, field, value)
}
\arguments{
\item{file}{path to file with toml text}

\item{as_json}{return output as json string instead of R list}

\item{toml}{string}

\item{x}{vector or json string to convert to TOML}

\item{auto_unbox}{convert atomic vectors of length 1 as scalars in TOML, unless
they are wrapped in \code{I()}. See also \link[jsonlite:fromJSON]{jsonlite::toJSON}.}

\item{field}{name of field to change, for example \code{package.version}.}

\item{value}{new value of field to set.}
}
\value{
\code{parse_toml()} returns a list and \code{edit_toml()} returns the modified
TOML text.
}
\description{
The \code{\link[=edit_toml]{edit_toml()}} function modifies values in a TOML text while retaining the
order, comments, and whitespace. Use \code{read_toml()} and \code{write_toml()} to convert
between TOML text and R lists.
}
\examples{
toml <- readLines('https://raw.githubusercontent.com/posit-dev/air/refs/heads/main/Cargo.toml')
toml <- edit_toml(toml, 'workspace.package.rust-version', '1.84')
toml <- edit_toml(toml, 'workspace.dependencies.bla', list(path = "./yolo", rev = "123"))
}
\references{
\href{https://github.com/rainbowatcher/toml-edit-js/blob/main/tests/edit.test.ts}{toml-edit-js examples}
}
