% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coersion-tk_zooreg.R
\name{tk_zooreg_dispatch_}
\alias{tk_zooreg_dispatch_}
\alias{tk_zooreg_.data.frame}
\alias{tk_zooreg_.default}
\title{S3 methods for zooreg method dispatch}
\usage{
tk_zooreg_dispatch_(
  data,
  select,
  date_var,
  start,
  end,
  frequency,
  deltat,
  ts.eps,
  order.by,
  silent
)

tk_zooreg_.data.frame(
  data,
  select,
  date_var,
  start,
  end,
  frequency,
  deltat,
  ts.eps,
  order.by,
  silent
)

tk_zooreg_.default(
  data,
  select,
  date_var,
  start,
  end,
  frequency,
  deltat,
  ts.eps,
  order.by,
  silent
)
}
\arguments{
\item{data}{A time-based tibble or time-series object.}

\item{select}{\strong{Applicable to tibbles and data frames only}.
The column or set of columns to be coerced to \code{zooreg} class.}

\item{date_var}{\strong{Applicable to tibbles and data frames only}.
Column name to be used to \code{order.by}.
\code{NULL} by default. If \code{NULL}, function will find the date or date-time column.}

\item{start}{the time of the first observation.  Either a single number or
    a vector of two integers, which specify a natural time unit
    and a (1-based) number of samples into the time unit.}

\item{end}{the time of the last observation, specified in the same way
    as \code{start}.}

\item{frequency}{the number of observations per unit of time.}

\item{deltat}{the fraction of the sampling period between successive
    observations; e.g., 1/12 for monthly data.  Only one of
    \code{frequency} or \code{deltat} should be provided.}

\item{ts.eps}{time series comparison tolerance.  Frequencies are considered
    equal if their absolute difference is less than \code{ts.eps}.}

\item{order.by}{a vector by which the observations in \code{x}
    are ordered. If this is specified the arguments \code{start} and
    \code{end} are ignored and \code{zoo(data, order.by, frequency)} is
    called. See \code{\link[zoo]{zoo}} for more information.}

\item{silent}{Used to toggle printing of messages and warnings.}
}
\value{
A character vector
}
\description{
Method dispatch for Zooreg
}
\keyword{internal}
