% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coersion-tk_ts.R
\name{tk_ts_dispatch_}
\alias{tk_ts_dispatch_}
\alias{tk_ts_.data.frame}
\alias{tk_ts_.default}
\title{S3 methods for ts method dispatch}
\usage{
tk_ts_dispatch_(data, select, start, end, frequency, deltat, ts.eps, silent)

tk_ts_.data.frame(data, select, start, end, frequency, deltat, ts.eps, silent)

tk_ts_.default(data, select, start, end, frequency, deltat, ts.eps, silent)
}
\arguments{
\item{data}{A time-based tibble or time-series object.}

\item{select}{\strong{Applicable to tibbles and data frames only}.
The column or set of columns to be coerced to \code{ts} class.}

\item{start}{the time of the first observation.  Either a single
    number or a vector of two numbers (the second of which is an integer),
    which specify a natural time
    unit and a (1-based) number of samples into the time unit.  See
    the examples for the use of the second form.}

\item{end}{the time of the last observation, specified in the same way
    as \code{start}.}

\item{frequency}{the number of observations per unit of time.}

\item{deltat}{the fraction of the sampling period between successive
    observations; e.g., 1/12 for monthly data.  Only one of
    \code{frequency} or \code{deltat} should be provided.}

\item{ts.eps}{time series comparison tolerance.  Frequencies are
    considered equal if their absolute difference is less than
    \code{ts.eps}.}

\item{silent}{Used to toggle printing of messages and warnings.}
}
\value{
A character vector
}
\description{
Method dispatch for ts
}
\keyword{internal}
