% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timelineG.R
\name{timelineG}
\alias{timelineG}
\title{Faceted Timelines for Grouped Data}
\usage{
timelineG(df, start, end, names, phase = NA, group1 = NA, group2 = NA,
          width = 2, color = "grey", theme = NULL, other = NULL)
}
\arguments{
\item{df}{Data frame containing start dates, end dates, groups, phases, and names for each timeline.}

\item{start}{Column in df for start dates.}

\item{end}{Column in df for end dates.}

\item{names}{Column in df for names of each timeline}

\item{phase}{Column in df for phases.}

\item{group1}{Column in df for groups to be used as the rows of the tabular display. Default is NA.}

\item{group2}{Column in df for groups to be used as the columns of the tabular display. Default is NA.}

\item{width}{Width of each timeline. Default is 2.}

\item{color}{Color of timelines, only used when \code{phase} is not provided.}

\item{theme}{Add theme elements if needed.}

\item{other}{Add other elements if needed.}
}
\description{
Plots faceted timelines for grouped data.
}
\examples{
### Plot timelines row-grouped by "Country"
timelineG(df = life_country, start = "Start", end = "End", names = "Name",
phase = "Phase", group1 = "Country")

### Plot timelines row-grouped by "Country" and column-grouped by "Gender"
timelineG(df = life_country, start = "Start", end = "End", names = "Name",
phase = "Phase", group1 = "Country", group2 = "Gender")

 ### Plot timelines, no group
timelineG(df = life_country, start = "Start", end = "End", names = "Name",color = "grey")

}
\author{
Dahee Lee
}
\seealso{
\code{\link{timelineS}}
}

