% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_test.R
\name{normal_test}
\alias{normal_test}
\title{Perform normality test on a variable}
\usage{
normal_test(data = NULL, var = NULL, group = NULL, norm = "auto")
}
\arguments{
\item{data}{A data frame containing the variables to be tested.}

\item{var}{A character string specifying the numeric variable in \code{data} to test.}

\item{group}{A character string specifying the grouping variable in \code{data}. If \code{NULL}, treated as one group.}

\item{norm}{Control parameter for test behavior. Accepts:
\itemize{
\item \code{'auto'}: Automatically decide based on p-values, but the same as \code{'ask'} when n > 1000, default
\item \code{'ask'}: Show p-values, plots QQ plots and prompts for decision
\item \code{TRUE}/\code{'true'}: Always returns \code{TRUE}
\item \code{FALSE}/\code{'false'}: Always returns \code{FALSE}
}}
}
\value{
A logical value:
\itemize{
\item \code{TRUE}: data are normally distributed
\item \code{FALSE}: data are not normally distributed
}
}
\description{
Conducts normality tests for a specified variable, optionally by group. Supports automatic testing and interactive visualization.
}
\section{Methodology for p-values}{

Automatically selects test based on sample size per group:
\itemize{
\item n < 3: Too small, assuming non-normal
\item (3, 50] Shapiro-Wilk test
\item (50, 1000]: D'Agostino Chi2 test, instead of Kolmogorov-Smirnov test
\item n > 1000: Show p-values, plots QQ plots and prompts for decision
}
}

\examples{
normal_test(iris, "Sepal.Length", "Species", norm = "auto")
normal_test(iris, "Sepal.Length", "Species", norm = TRUE)

}
