% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{to_sql_case}
\alias{to_sql_case}
\title{Extract SQL case statement from a \link{rulelist}}
\usage{
to_sql_case(rulelist, rhs_column_name = "RHS", output_colname = "output")
}
\arguments{
\item{rulelist}{A \link{rulelist} object}

\item{rhs_column_name}{(string, default: "RHS") Name of the column in the
rulelist to be used as RHS (WHEN some_rule THEN rhs) in the sql case
statement}

\item{output_colname}{(string, default: "output") Name of the output column
created by the SQL statement (used in case ... AS output_column)}
}
\value{
(string invisibly) SQL case statement
}
\description{
Extract SQL case statement from a \link{rulelist}
}
\details{
As a side-effect, the SQL statement is cat to stdout. The output
contains newline character.
}
\examples{
model_c5 = C50::C5.0(Attrition ~., data = modeldata::attrition, rules = TRUE)
tidy(model_c5)
to_sql_case(tidy(model_c5))
}
\seealso{
\link{rulelist}, \link{tidy}, \link[=augment.rulelist]{augment}, \link[=predict.rulelist]{predict}, \link{convert_rule_flavor}

Other Auxiliary Rulelist Utility: 
\code{\link{convert_rule_flavor}()}
}
\concept{Auxiliary Rulelist Utility}
