% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ruleset.R
\name{predict.ruleset}
\alias{predict.ruleset}
\title{\code{predict} method for a \link{ruleset}}
\usage{
\method{predict}{ruleset}(object, new_data, ...)
}
\arguments{
\item{object}{A \link{ruleset}}

\item{new_data}{(dataframe)}

\item{...}{unused}
}
\value{
A dataframe with three or more columns: \code{row_number} (int), columns
corresponding to 'keys', \code{rule_nbr} (list column of integers). If a row
number and 'keys' combination is not covered by any rule, then \code{rule_nbr}
column has missing value.
}
\description{
Predicts multiple \code{rule_nbr}(s) applicable for a \code{row_nbr} (per
key) in new_data
}
\examples{
model_c5 = C50::C5.0(species ~.,
                     data = palmerpenguins::penguins,
                     trials = 5,
                     rules = TRUE
                     )
tidy_c5_ruleset = as_ruleset(tidy(model_c5))
tidy_c5_ruleset

predict(tidy_c5_ruleset, palmerpenguins::penguins)

}
\seealso{
\link{predict.rulelist}
}
