% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_matrix.R
\name{read_q_files}
\alias{read_q_files}
\title{Read and structure .Q files or existing matrices as \code{q_matrix} or \code{gt_admix}
objects.}
\usage{
read_q_files(x)
}
\arguments{
\item{x}{can be:
\itemize{
\item a path to a directory containing .Q files
}}
}
\value{
\itemize{
\item a \code{gt_admix} object containing a list of Q matrices and a list of
indices for each Q matrix separated by K
}
}
\description{
This function reads .Q matrix files generated by external clustering
algorithms (such as ADMIXTURE) and transforms them into \code{gt_admix} objects.
}
\examples{
q_files_path <- system.file("extdata", "anolis", package = "tidypopgen")

admix_obj <- read_q_files(q_files_path)
summary(admix_obj)
}
