% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-clustering.R
\name{tidy_clara}
\alias{tidy_clara}
\title{Tidy CLARA (Clustering Large Applications)}
\usage{
tidy_clara(data, k, metric = "euclidean", samples = 50, sampsize = NULL)
}
\arguments{
\item{data}{A data frame or tibble}

\item{k}{Number of clusters}

\item{metric}{Distance metric (default: "euclidean")}

\item{samples}{Number of samples to draw (default: 50)}

\item{sampsize}{Sample size (default: min(n, 40 + 2*k))}
}
\value{
A list of class "tidy_clara" containing clustering results
}
\description{
Performs CLARA clustering (scalable version of PAM)
}
\examples{
\donttest{
# CLARA for large datasets
large_data <- iris[rep(1:nrow(iris), 10), 1:4]
clara_result <- tidy_clara(large_data, k = 3, samples = 50)
print(clara_result)
}

}
