% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate-keys.R
\name{validate_var_relationship}
\alias{validate_var_relationship}
\alias{print.validate_var_rel}
\title{Validate Variable Relationship}
\usage{
validate_var_relationship(.data, var1, var2)

\method{print}{validate_var_rel}(x, ...)
}
\arguments{
\item{.data}{A data.frame or tibble.}

\item{var1}{Character string: name of the first variable.}

\item{var2}{Character string: name of the second variable.}

\item{x}{An object to print.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An S3 object of class \code{validate_var_rel} containing:
\describe{
\item{table_name}{Name of the input table}
\item{var1, var2}{Names of the variables analyzed}
\item{relation}{Character string: "one-to-one", "one-to-many",
"many-to-one", or "many-to-many"}
\item{var1_unique}{Number of distinct values in var1}
\item{var2_unique}{Number of distinct values in var2}
\item{n_combinations}{Number of unique (var1, var2) pairs}
\item{var1_has_dups}{Does any var1 value map to multiple var2 values?}
\item{var2_has_dups}{Does any var2 value map to multiple var1 values?}
}
}
\description{
Determines the relationship between two variables in a data.frame:
one-to-one, one-to-many, many-to-one, or many-to-many.
}
\details{
Only accepts variables of type character, integer, or factor. Numeric
(double) variables are not allowed due to floating-point comparison issues.
}
\examples{
df <- data.frame(
  person_id = c(1L, 2L, 3L, 4L),
  department = c("Sales", "Sales", "Engineering", "Engineering"),
  country = c("US", "US", "US", "UK")
)
validate_var_relationship(df, "person_id", "department")

}
\seealso{
Other join validation: 
\code{\link{compare_tables}()},
\code{\link{validate_join}()},
\code{\link{validate_primary_keys}()}
}
\concept{join validation}
