% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-summary.R
\name{diagnose_nas}
\alias{diagnose_nas}
\alias{print.diagnose_na}
\title{Diagnose Missing Values}
\usage{
diagnose_nas(.data)

\method{print}{diagnose_na}(x, ...)
}
\arguments{
\item{.data}{A data.frame or tibble to diagnose.}

\item{x}{An object to print.}

\item{...}{Additional arguments (currently unused).}
}
\value{
An S3 object of class \code{diagnose_na} containing:
\describe{
\item{table}{A data.frame with columns \code{variable}, \code{n_na}, \code{pct_na}, and
\code{n_valid}, sorted by \code{pct_na} descending.}
\item{n_cols}{Total number of columns in the input.}
\item{n_with_na}{Number of columns that have at least one NA.}
}
}
\description{
Reports NA counts and percentages for each column in a data.frame, sorted
by missing percentage in descending order.
}
\examples{
df <- data.frame(
  a = c(1, NA, 3),
  b = c(NA, NA, "x"),
  c = c(TRUE, FALSE, TRUE)
)
diagnose_nas(df)

}
\seealso{
Other data quality: 
\code{\link{audit_transform}()},
\code{\link{diagnose_strings}()},
\code{\link{get_summary_table}()},
\code{\link{summarize_column}()}
}
\concept{data quality}
