% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit-tap.R
\name{audit_tap}
\alias{audit_tap}
\title{Record a Pipeline Snapshot}
\usage{
audit_tap(.data, .trail, label = NULL, .fns = NULL)
}
\arguments{
\item{.data}{A data.frame or tibble flowing through the pipe.}

\item{.trail}{An \code{\link[=audit_trail]{audit_trail()}} object.}

\item{label}{Optional character label for this snapshot. If \code{NULL}, an
auto-generated label like \code{"step_1"} is used.}

\item{.fns}{Optional named list of diagnostic functions (or formula lambdas)
to run on \code{.data}. Results are stored in the snapshot.}
}
\value{
\code{.data}, unchanged, returned invisibly. The function is a
transparent pass-through; its only effect is the side effect on \code{.trail}.
}
\description{
Transparent pipe pass-through that captures a metadata snapshot and appends
it to an audit trail. Returns \code{.data} unchanged — the function's only purpose
is its side effect on \code{.trail}.
}
\examples{
trail <- audit_trail("example")
result <- mtcars |>
  audit_tap(trail, "raw") |>
  dplyr::filter(mpg > 20) |>
  audit_tap(trail, "filtered")
print(trail)

}
\seealso{
Other audit trail: 
\code{\link{audit_diff}()},
\code{\link{audit_report}()},
\code{\link{print.audit_snap}()}
}
\concept{audit trail}
