% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{annotation_tile}
\alias{annotation_tile}
\alias{annotation_tile,InputHeatmap-method}
\title{Adds a tile annotation layer to a `InputHeatmap`, that on evaluation creates a `ComplexHeatmap`}
\source{
[Mangiola and Papenfuss., 2020](https://joss.theoj.org/papers/10.21105/joss.02472)
}
\usage{
annotation_tile(.data, .column, palette = NULL, size = NULL, ...)

\S4method{annotation_tile}{InputHeatmap}(.data, .column, palette = NULL, size = NULL, ...)
}
\arguments{
\item{.data}{a `InputHeatmap` object created calling `tidyHeatmap::heatmap()`}

\item{.column}{Vector of quotes}

\item{palette}{A character vector of colors, or a function such as colorRamp2 (see examples).}

\item{size}{A grid::unit object, e.g. unit(2, "cm"). This is the height or width of the annotation depending on the orientation.}

\item{...}{The arguments that will be passed to 
\code{\link[ComplexHeatmap:anno_block]{anno_block}} and 
\code{\link[ComplexHeatmap:HeatmapAnnotation]{HeatmapAnnotation}}
if you want to fine tune the aesthetics.}
}
\value{
A `InputHeatmap` object that gets evaluated to a `ComplexHeatmap`

A `InputHeatmap` object that gets evaluated to a `ComplexHeatmap`
}
\description{
annotation_tile() from a `InputHeatmap` object, adds a tile annotation layer.
}
\details{
\lifecycle{maturing}

It uses `ComplexHeatmap` as visualisation tool.
}
\examples{


hm = 
  tidyHeatmap::N52 |>
  tidyHeatmap::heatmap(
    .row = symbol_ct,
    .column = UBR,
    .value = `read count normalised log`
)

hm |> annotation_tile(CAPRA_TOTAL)


hm |> 
  annotation_tile(
    inflection, 
    palette = circlize::colorRamp2(c(0, 3,10), c("white", "green", "red"))
 )

}
\references{
Mangiola, S. and Papenfuss, A.T., 2020. "tidyHeatmap: an R package for 
  modular heatmap production based on tidy principles." Journal of Open Source Software.
  doi:10.21105/joss.02472.
}
