% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{truncate}
\alias{truncate}
\alias{trunc_amp}
\title{Truncate reads}
\usage{
trunc_amp(
  loci = NULL,
  in_dir,
  trunc_fr,
  fw_pattern,
  rv_pattern = NULL,
  outdir = tempdir(),
  filt_name = "_F_filt.fastq.gz",
  mode_trun = "pe",
  multithread = FALSE,
  max_ee = 3,
  trunc_q = 2
)
}
\arguments{
\item{loci}{Character vector with loci. If NULL, all loci detected by
'check_names_demultiplexed()' are processed.}

\item{in_dir}{Path to folder with demultiplexed reads "sample.locus.
[1|2].fastq.gz".}

\item{trunc_fr}{Flexible argument that sets truncation length for F
(and R) reads.
\itemize{
\item If 'numeric' of length == 1, trunFR is used for F and optionally R
reads, trunc_f = trunc_r.
\item If 'numeric' of length == 2, the first and second positions are used
as truncation lengths in F and R reads, accross all loci.
\item If it is a 'dataframe' with 'colnames == c("locus", "trunc_f", "trunc_r")
', locus-spefic truncation lengths are applied from 'trunc_f' and 'trunc_r'
columns. If 'se', 'trunc_r' values are ignored.
}}

\item{fw_pattern}{Pattern matching specific extension of forward reads.}

\item{rv_pattern}{Pattern matching specific extension of reverse reads.}

\item{outdir}{Path where filtered reads are written. Created if it does
not exist.}

\item{filt_name}{Pattern to append to FASTA names: '\{sample\}_\{locus\}\{filt_name\}'.}

\item{mode_trun}{'se': single-end; 'pe', paired-end.}

\item{multithread}{T/F, see 'filterAndTrim()'.}

\item{max_ee}{Maximum expected errors. See 'filterAndTrim()'.}

\item{trunc_q}{Trim low-quality bases from 3' end.
See 'filterAndTrim()'.}
}
\value{
List with dataframes of number of reads before and after truncation.
It writes truncated sequence to "outdir"
}
\description{
Truncates reads using 'filterAndTrim()' from DADA2. It automatically detects
single-end or paired-end sequencing files.
}
\examples{
dem <-
 system.file("extdata", "demultiplexed", package = "tidyGenR")
# single end
trunc_amp(
    mode_trun = "pe",
    in_dir = dem,
    fw_pattern = "1.fastq.gz",
    rv_pattern = "2.fastq.gz",
    trunc_fr = c(250, 180),
    max_ee = c(3, 3)
)
# paired-end
data("trunc_fr")
trunc_amp(
    mode_trun = "se",
    loci = c("chrna9", "nfkbia"),
    in_dir = dem,
    fw_pattern = "1.fastq.gz",
    rv_pattern = "2.fastq.gz",
    trunc_fr = trunc_fr,
    max_ee = 3,
    trunc_q = 2
)
}
