% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_raw_reads.R
\name{check_raw_reads}
\alias{check_raw_reads}
\title{Check input raw FASTA/Q files}
\usage{
check_raw_reads(freads, rreads = NULL, low_readcount = 10)
}
\arguments{
\item{freads}{Character vector with file paths to forward reads.}

\item{rreads}{Character vector with file paths to reverse reads.}

\item{low_readcount}{Numeric threshold to warn on number of reads in FASTA
(DEFAULT = 10).}
}
\value{
List with 4 elements:
\itemize{
\item 'f_reads', character vector with basename of forward reads.
\item 'r_reads', character vector with basename of reads reads
or NULL for single-end experiments.
\item 'snames', character vector with sample names.
\item 'checks', Logical vector with passed checks 1-3.
}
}
\description{
Check input raw FASTA/Q files
}
\details{
Multiple checks on raw input FASTQ:
\itemize{
\item Reads in FASTQ above threshold.
\item Unique sample names.
\item Not orphan F/R files for paired reads.
For single-end data check 3 is excluded and NULL is returned in \code{checks[4]}.
}
}
\examples{
freads <-
list.files(system.file("extdata", "raw", package = "tidyGenR"),
pattern = "1.fastq.gz",
    full.names = TRUE)
check_raw_reads(freads)
}
