% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tic_auc.R
\name{tic_auc}
\alias{tic_auc}
\title{Return area under curve from time-intensity data}
\usage{
tic_auc(data, timevar, intensityvar, AUCmax = NULL, plotresult = FALSE)
}
\arguments{
\item{data}{A dataframe with time and intensity values as columns.}

\item{timevar}{A character string (in quotes) with the dataframe column name for the time variable.}

\item{intensityvar}{A character string (in quotes) with dataframe column name for the intensity variable.}

\item{AUCmax}{A number - the maximum time that area under the curve is measured until.}

\item{plotresult}{TRUE or FALSE to determine whether a plot of the results is generated.}
}
\value{
Area under the curve. Depending on the plotresult argument can also
return a plot of the raw data.
}
\description{
This function returns area under curve from raw time intensity curves using
the trapezoid method. It is recommended that plotresult is set to TRUE in the
first instance to visually confirm the analysis.
}
\details{
A plot of the data is generated and a dataframe with the results is returned.
}
\examples{

# Example usage: Please see package vignettes on CRAN

}
