% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palettes.R
\name{show_palettes}
\alias{show_palettes}
\title{Show the color palettes}
\usage{
show_palettes(
  palettes = NULL,
  type = c("discrete", "continuous"),
  index = NULL,
  palette_names = NULL,
  return_names = TRUE,
  return_palettes = FALSE
)
}
\arguments{
\item{palettes}{A list of color palettes.
Default is \code{NULL}.}

\item{type}{The type of palettes to include.
Default is \code{"discrete"}.}

\item{index}{The indices of the palettes to include.
Default is \code{NULL}.}

\item{palette_names}{The names of the palettes to include.
Default is \code{NULL}.}

\item{return_names}{Whether to return the names of the selected palettes.
Default is \code{TRUE}.}

\item{return_palettes}{Whether to return the colors of selected palettes.
Default is \code{FALSE}.}
}
\value{
If \code{return_palettes} is \code{TRUE}, returns a list of color palettes. If \code{return_names} is \code{TRUE} (default), returns a character vector of palette names. Otherwise, returns \code{NULL} (called for side effects to display the plot).
}
\description{
This function displays color palettes using ggplot2.
}
\examples{
show_palettes(
  palettes = list(
    c("red", "blue", "green"),
    c("yellow", "purple", "orange")
  )
)
all_palettes <- show_palettes(return_palettes = TRUE)
names(all_palettes)
all_palettes[["simspec"]]
show_palettes(index = 1:10)
show_palettes(
  type = "discrete",
  index = 1:10
)
show_palettes(
  type = "continuous",
  index = 1:10
)
show_palettes(
  palette_names = c(
    "Paired", "nejm", "simspec", "Spectral", "jet", "Chinese"
  ),
  return_palettes = TRUE
)
# Include Chinese palettes via prefix
show_palettes(
  palette_names = c("ChineseRed", "ChineseBlue"),
  return_palettes = TRUE
)
}
\seealso{
\link{palette_colors}, \link{palette_list}
}
