% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{uc0}
\alias{uc0}
\title{Unobservable components (UC) for structural time series models}
\usage{
uc0(name, param, b, C = NULL, S = NULL)
}
\arguments{
\item{name}{character, name of the UC.}

\item{param}{a vector or list with the parameters of the UC.}

\item{b}{vector of the UC in the observation equation.}

\item{C}{matrix of the UC in the transition matrix.}

\item{S}{covariance matrix of the error vector driving the UC.}
}
\value{
An S3 object of class \code{\link{uc}}.
}
\description{
\code{uc0} constructs unobservable components by specifying their state-space
representation matrices. This is the helper function used internally by
\code{\link{uc}} to create predefined components like trends, seasonals, and
cycles.
}
\note{
Matrices b, C and S can include symbolic expressions in terms of the 
parameters of the model. These parameters are defined in the \code{param} 
argument with their corresponding names. See the \code{\link{ssm}} function
for more information about b, C and S.
}
\examples{

# Local linear trend component
param <- c(s2_lvl = 0.05, s2_slp = 0.025)
b <- c(1, 0)
C <- matrix(c(1, 1, 0, 1), 2, 2, byrow = TRUE)
S <- matrix(c("s2_lvl", "0", "0", "s2_slp"), 2, 2)
trend <- uc0("trend", param, b, C, S)

# Cycle component
param <- c(phi = 0.8, per = 5, s2c = 0.01)
b <- c(1, 0)
C <- matrix(c("phi*cos(2*pi/per)", "phi*sin(2*pi/per)", 
"-phi*sin(2*pi/per)", "phi*cos(2*pi/per)"), 2, 2, byrow = TRUE)
S <- matrix(c("s2c*(1 - phi^2)", "0", "0", "s2c*(1 - phi^2)"))
cycle <- uc0("cycle", param, b, C, S)

}
\references{
Durbin, J. and Koopman, S.J. (2012) Time Series Analysis by State Space
Methods, 2nd ed., Oxford University Press, Oxford.

Harvey, A.C. (1989) Forecasting, Structural Time Series Models and the Kalman
Filter. Cambridge University Press, Cambridge.
}
