% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{detect_sdg}
\alias{detect_sdg}
\title{Detect SDGs in text using ensemble model}
\usage{
detect_sdg(
  text,
  systems = lifecycle::deprecated(),
  output = lifecycle::deprecated(),
  sdgs = 1:17,
  synthetic = c("equal"),
  verbose = TRUE
)
}
\arguments{
\item{text}{\code{character} vector or object of class \code{tCorpus} containing text in which SDGs shall be detected. Not allowed to contain any missing values.}

\item{systems}{As of text2sdg 1.0.0 the `systems` argument of `detect_sdg()` is deprecated. This is because `detect_sdg()` now makes use of an ensemble approach that draws on all systems as well as on the text length, see --preprint-- for more information. The old version of `detect_sdg()` is available through the `detect_sdg_systems()` function.}

\item{output}{As of text2sdg 1.0.0 the `output` argument of `detect_sdg()` is deprecated. This is because `detect_sdg()` now makes use of an ensemble approach that draws on all systems as well as on the text length, see --preprint-- for more information. The old version of `detect_sdg()` is available through the `detect_sdg_systems()` function.}

\item{sdgs}{\code{numeric} vector with integers between 1 and 17 specifying the sdgs to identify in \code{text}. Defaults to \code{1:17}.}

\item{synthetic}{\code{character} vector specifying the ensemble version to be used. These versions vary in terms of the amount of synthetic data used in training (relative to the amount of expert-labeled data). Can be one or more of \code{"none"}, \code{"third"}, \code{"equal"}, and \code{"triple"}. The default is \code{"equal"}.}

\item{verbose}{\code{logical} specifying whether messages on the function's progress should be printed.}
}
\value{
The function returns a \code{tibble} containing the SDG hits found in the vector of documents. The columns of the \code{tibble} are described below. The \code{tibble} also includes as an attribute with name \code{"system_hits"} the predictions of the individual systems produced by \code{detect_sdg_systems()}.
\describe{
 \item{document}{Index of the element in \code{text} where match was found. Formatted as a factor with the number of levels matching the original number of documents.}
 \item{sdg}{Label of the SDG found in document.}
 \item{system}{The name of the ensemble system that produced the match.}
 \item{hit}{Index of hit for the Ensemble model.}
}
}
\description{
\code{detect_sdg} identifies SDGs in text using an ensemble model approach considering multiple existing SDG query systems and text length.
}
\details{
\code{detect_sdg} implements a ensemble model to detect SDGs in text. The ensemble model combines the six systems implemented by \code{\link{detect_sdg_systems}} and text length in a random forest architecture. The ensemble model has been trained on three data sets with SDG labels assigned by experts and a matching number of synthetic texts generated by random sampling from a word frequency list. The user has the choice of multiple versions of the ensemble model that have been trained on different amounts of synthetic texts to adjust the sensitivity and specificity of the model. Increasing the amount of of synthetic data makes the ensemble more conservative, leading to increased sensitivity and decreased specificity.

By default, \code{detect_sdg} implements the version of the ensemble model that has been trained on an equal amount of expert-labeled and synthetic data, providing a reasonable balance between sensitivity and specificity. For details, see article by Wulff et al. (2024).
}
\examples{
\donttest{
# run sdg detection
hits <- detect_sdg(projects)

# run sdg detection for sdg 3 only
hits <- detect_sdg(projects, sdgs = 3)

# extract systems hits
attr(hits, "system_hits")
}
}
\references{
Wulff, D. U., Meier, D. S., & Mata, R. (2024). Using novel data and ensemble models to improve automated labeling of Sustainable Development Goals. Sustainability Science. https://doi.org/10.1007/s11625-024-01516-3
}
