% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_alpha_e0.R
\name{priorOnE0_spec}
\alias{priorOnE0_spec}
\title{Specify prior on e0.}
\usage{
priorOnE0_spec(E = c("G_1_20", "e0const"), e0)
}
\arguments{
\item{E}{A character indicating which specification should be used.}

\item{e0}{A numeric scalar giving the fixed value of \eqn{e_0}.}
}
\value{
A named list containing:
\itemize{
\item \code{"log_p_e0"}: a function of the log prior of \eqn{e_0}.
\item \code{"param"}: a list with the parameters.
}
}
\description{
Obtain a function to evaluate the log prior specified
for \eqn{e_0}.
}
\details{
The following prior specifications are supported:
\itemize{
\item \code{"G_1_20"}: \eqn{e_0 \sim} gamma(1, 20), i.e., shape = 1, rate = 20.
\item \code{"e0const"}: \eqn{e_0} is fixed at \code{e0}.
}
}
