% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_labels.R
\name{countBar}
\alias{countBar}
\alias{updateCountBar}
\alias{updateCountText}
\title{Progress bar with label}
\usage{
countBar(inputId, label, countmax, countnow = NULL, counttotal = countmax)

updateCountBar(
  session = getDefaultReactiveDomain(),
  inputId,
  label,
  countmax,
  countnow = NULL,
  counttotal
)

updateCountText(
  session = getDefaultReactiveDomain(),
  inputId,
  label,
  countmax,
  countnow
)
}
\arguments{
\item{inputId}{(\code{character(1)}) \code{shiny} id of the parent element (e.g. a check-box group input).}

\item{label}{(\code{character(1)}) Text to display followed by counts.}

\item{countmax}{(\code{numeric(1)}) Maximum count for a single element.}

\item{countnow}{(\code{numeric(1)}) Current count for a single element.}

\item{counttotal}{(\code{numeric(1)}) Sum total of maximum counts of all elements, see \code{Details}.}

\item{session}{(\code{session}) \code{shiny} \code{session} object passed to function given to \code{shinyServer}.}
}
\value{
\code{shiny.tag} object with a progress bar and a label.
}
\description{
\code{shiny} element displaying a progress bar and observation count.
}
\details{
A progress bar is created to visualize the number of counts in a variable, with filling and a text label.
\itemize{
\item progress bar width is derived as a fraction of the container width equal to \verb{<countmax> / <counttotal>\%"},
\item progress bar is filled up to the fraction \verb{<countnow> / <countmax>},
\item text label is obtained by \verb{<label> (<countnow> / <countmax>)}.
}
}
\keyword{internal}
