% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters_var_labels.R
\name{col_labels}
\alias{col_labels}
\alias{col_labels<-}
\alias{col_relabel}
\title{Variable labels}
\source{
These functions were taken from
\href{https://cran.r-project.org/package=formatters}{formatters} package, to reduce the complexity of
the dependency tree and rewritten.
}
\usage{
col_labels(x, fill = FALSE)

col_labels(x) <- value

col_relabel(x, ...)
}
\arguments{
\item{x}{(\code{data.frame} or \code{DataFrame}) data object}

\item{fill}{(\code{logical(1)}) specifying what to return if variable has no label}

\item{value}{(\code{character}) vector of variable labels of length equal to number of columns in \code{x};
if named, names must match variable names in \code{x} and will be used as key to set labels;
use \code{NA} to remove label from variable}

\item{...}{name-value pairs, where name corresponds to a variable name in \code{x}
and value is the new variable label; use \code{NA} to remove label from variable}
}
\value{
For \code{col_labels}, named character vector of variable labels, the names being the corresponding variable names.
If the \code{label} attribute is missing, the vector elements will be
the variable names themselves if \code{fill = TRUE} and \code{NA} if \code{fill = FALSE}.

For \verb{col_labels<-} and \code{col_relabel}, copy of \code{x} with variable labels modified.
}
\description{
Get or set variable labels in a \code{data.frame}.
}
\details{
Variable labels can be stored as a \code{label} attribute set on individual variables.
These functions get or set this attribute, either on all (\code{col_labels}) or some variables (\code{col_relabel}).
}
\examples{
x <- iris
col_labels(x)
col_labels(x) <- paste("label for", names(iris))
col_labels(x)
y <- col_relabel(x, Sepal.Length = "Sepal Length of iris flower")
col_labels(y)

}
