% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dev_suppress}
\alias{dev_suppress}
\title{Suppresses plot display in the IDE by opening a PDF graphics device}
\usage{
dev_suppress(x)
}
\arguments{
\item{x}{lazy binding which generates the plot(s)}
}
\value{
No return value, called for side effects.
}
\description{
This function opens a PDF graphics device using \code{\link[grDevices:pdf]{grDevices::pdf}} to suppress
the plot display in the IDE. The purpose of this function is to avoid opening graphic devices
directly in the IDE.
}
\details{
The function uses \code{\link[base:on.exit]{base::on.exit}} to ensure that the PDF graphics
device is closed (using \code{\link[grDevices:dev]{grDevices::dev.off}}) when the function exits,
regardless of whether it exits normally or due to an error. This is necessary to
clean up the graphics device properly and avoid any potential issues.
}
\examples{
dev_suppress(plot(1:10))
}
