% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_rep_index.R
\name{tar_rep_index}
\alias{tar_rep_index}
\title{Get overall rep index.}
\usage{
tar_rep_index()
}
\value{
Positive integer from 1 to \code{batches * reps},
index of the current replication in an ongoing pipeline.
}
\description{
Get the integer index of the current replication
in certain target factories.
}
\details{
\code{\link[=tar_rep_index]{tar_rep_index()}} cannot run in your interactive R session
or even the setup portion of \verb{_targets.R}.
It must be part of the R command of a target actively
running in a pipeline.

In addition, \code{\link[=tar_rep_index]{tar_rep_index()}} is only compatible with
\code{\link[=tar_rep]{tar_rep()}}, \code{\link[=tar_rep2]{tar_rep2()}}, \code{\link[=tar_map_rep]{tar_map_rep()}}, \code{\link[=tar_map2_count]{tar_map2_count()}},
and \code{\link[=tar_map2_size]{tar_map2_size()}}.
In the latter 3 cases, \code{\link[=tar_rep_index]{tar_rep_index()}} cannot be part of
the \code{values} or \code{command1} arguments.

In \code{\link[=tar_map_rep]{tar_map_rep()}}, each row of the \code{values} argument
(each "scenario") gets its own independent set of index values from 1 to
\code{batches * reps}.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  tar_map_rep(
    x,
    data.frame(index = tar_rep_index()),
    batches = 2L,
    reps = 3L,
    values = list(value = c("a", "b"))
  )
})
targets::tar_make()
x <- targets::tar_read(x)
all(x$index == x$tar_rep + (3L * (x$tar_batch - 1L)))
#> TRUE
})
}
}
\concept{Dynamic batched replication indexing}
