% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust-numeric-calibration.R
\name{adjust_numeric_calibration}
\alias{adjust_numeric_calibration}
\title{Re-calibrate numeric predictions}
\usage{
adjust_numeric_calibration(x, method = NULL, ...)
}
\arguments{
\item{x}{A \code{\link[=tailor]{tailor()}}.}

\item{method}{Character. One of \code{"linear"}, \code{"isotonic"},\code{"isotonic_boot"},
or \code{"none"}, corresponding to the function from the \pkg{probably}
package \code{probably::cal_estimate_linear()},
\code{probably::cal_estimate_isotonic()}, or
\code{probably::cal_estimate_isotonic_boot()}, respectively. The default is to
use \code{"linear"} which, despite its name, fits a generalized additive model.
Note that when \code{\link[=fit.tailor]{fit.tailor()}} is called, the value may be changed to \code{"none"}
if there is insufficient data.}

\item{...}{Optional arguments to pass to the corresponding function in the
\pkg{probably} package. These arguments must be named.}
}
\value{
An updated \code{\link[=tailor]{tailor()}} containing the new operation.
}
\description{
Calibration for regression models involves adjusting the model's
predictions to adjust for correlated errors, ensuring that predicted
values align closely with actual observed values across the entire
range of outputs.
}
\details{
The "linear" method fits a model that predicts the observed versus the
predicted outcome values. This model is used to remove any overt systematic
trends from the data, equivalent to removing the model residuals from new
data. The underlying code fits that model using \code{\link[mgcv:gam]{mgcv::gam()}}. If
\code{smooth = FALSE} is passed to the \code{...}, it uses \code{\link[stats:lm]{stats::lm()}}.

The isotonic method uses \code{\link[stats:isoreg]{stats::isoreg()}} to force the predicted values to
increase with the observed outcome. This creates a step function that will
map new predictions to values that are monotonically increasing with the
outcome. One side effect is that there are fewer, perhaps far fewer, unique
predicted values. The "isotonic boot" method resamples the data and generates
multiple isotonic regressions that are averaged and used to correct the
predictions. This may not be perfectly monotonic, but the number of unique
calibrated predictions increases with the number of bootstrap samples
(controlled by passing the \code{times} argument to \code{...}).
}
\section{Data Usage}{

This adjustment requires estimation and, as such, different subsets of data
should be used to train it and evaluate its predictions.

Note that, when calling \code{\link[=fit.tailor]{fit.tailor()}}, if the calibration data have zero or
one row, the \code{method} is changed to \code{"none"}.
}

\examples{
\dontshow{if (rlang::is_installed("probably")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tibble)

# create example data
set.seed(1)
d_calibration <- tibble(y = rnorm(100), y_pred = y/2 + rnorm(100))
d_test <- tibble(y = rnorm(100), y_pred = y/2 + rnorm(100))

d_calibration

# specify calibration
tlr <-
  tailor() |>
  adjust_numeric_calibration(method = "linear")

# train tailor on a subset of data.
tlr_fit <- fit(tlr, d_calibration, outcome = y, estimate = y_pred)

# apply to predictions on another subset of data
d_test

predict(tlr_fit, d_test)
\dontshow{\}) # examplesIf}
}
