% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{style_column}
\alias{style_column}
\title{style_column}
\usage{
style_column(
  tbl,
  columns = dplyr::everything(),
  rows = NULL,
  background_color = "#ffffff",
  text_color = "#000000",
  font_size = NULL,
  bold = FALSE,
  italic = FALSE,
  color_scale = NULL,
  openxlsx_style = NULL,
  gt_style = NULL,
  stack = TRUE
)
}
\arguments{
\item{tbl}{tablespan table}

\item{columns}{the columns to style. Must be a tidyselect selector expression (e.g., starts_with("hp_"))}

\item{rows}{indices of the rows which should be styled. When set to NULL, the style is applied to all rows}

\item{background_color}{hex code for the background color}

\item{text_color}{hex code for the text color}

\item{font_size}{font size}

\item{bold}{set to TRUE for bold}

\item{italic}{set to TRUE for italic}

\item{color_scale}{a named vector of length 2 or 3 to define a color scale. Example for two colors: color_scale = c("#EE2F43" = -1, "#37E65A" = 1).
Example for three colors: color_scale = c("#EE2F43" = -1, "#FFFFFF" = 0, "#37E65A" = 1)}

\item{openxlsx_style}{optional custom openxlsx style. When provided, all other arguments are ignored}

\item{gt_style}{optional custom gt style. When provided, all other arguments are ignored}

\item{stack}{When set to TRUE, the style is added on top of the existing styles. This is mostly relevant
for openxlsx. When set to FALSE, the new style replaces all previous styling.}
}
\value{
the tablespan table with added styles
}
\description{
Change the style of a column or single cells within columns.
}
\examples{
library(tablespan)
library(dplyr)
data("mtcars")

# We want to report the following table:
summarized_table <- mtcars |>
  group_by(cyl, vs) |>
  summarise(N = n(),
            mean_hp = mean(hp),
            sd_hp = sd(hp),
            mean_wt = mean(wt),
            sd_wt = sd(wt))

# Create a tablespan:
tbl <- tablespan(data = summarized_table,
                 formula = Cylinder:cyl + Engine:vs ~
                   N +
                   (`Horse Power` = Mean:mean_hp + SD:sd_hp) +
                   (`Weight` = Mean:mean_wt + SD:sd_wt),
                 title = "Motor Trend Car Road Tests",
                 subtitle = "A table created with tablespan",
                 footnote = "Data from the infamous mtcars data set.")

tbl |>
  style_column(columns = mean_hp,
               bold = TRUE) |>
  as_gt()
}
