% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabbit_excel.R
\name{tabbit_excel}
\alias{tabbit_excel}
\title{Write Weighted Crosstab Tables To An Excel Workbook}
\usage{
tabbit_excel(
  data,
  vars,
  breakdown,
  file,
  wtvar,
  row_pct = FALSE,
  decimals = 1L,
  nooverall = FALSE,
  nototal = FALSE,
  missingasrow = FALSE,
  nomissing = FALSE,
  by_breakdown = TRUE,
  sheet_base = "Frequencies",
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{vars}{Character vector of outcome variable names.}

\item{breakdown}{Character vector of breakdown variables.}

\item{file}{Path to the Excel file to create.}

\item{wtvar}{Name of the weight variable (string). Must be present in \code{data}.}

\item{row_pct}{Logical. If \code{FALSE} (default), tables show column
percentages. If \code{TRUE}, tables show row percentages.}

\item{decimals}{Integer. Number of decimal places for percentages (0-6;
default 1).}

\item{nooverall}{Logical. If \code{TRUE}, suppress the "Overall" column (or
"Overall column percentage (valid responses)" table).}

\item{nototal}{Logical. If \code{TRUE}, suppress the "Total percent" row in the
percentage table (column mode only).}

\item{missingasrow}{Logical. If \code{TRUE}, include "Response missing" as an
explicit row in the main percentage table.}

\item{nomissing}{Logical. If \code{TRUE}, drop missing responses from the
unweighted N table (and from the percentage table unless
\code{missingasrow = TRUE}).}

\item{by_breakdown}{Logical. If \code{TRUE} (default), create one sheet per
breakdown variable. If \code{FALSE}, stack all results into a single sheet
called \code{sheet_base}.}

\item{sheet_base}{Sheet name to use when \code{by_breakdown = FALSE}.}

\item{...}{For future extension.}
}
\value{
Invisibly, the file path of the created workbook (a character string).
}
\description{
\code{tabbit_excel()} produces weighted percentage tables and unweighted counts
for one or more outcome variables, optionally including missing responses
and/or row percentages. Output is written to an Excel file with one sheet per
breakdown variable by default (or all results in a single sheet if
\code{by_breakdown = FALSE}).
}
\details{
For each outcome variable in \code{vars} and each breakdown variable in
\code{breakdown}, \code{tabbit_excel()}:

\itemize{
\item computes weighted percentages (by column or by row),
\item optionally adds an overall distribution across breakdowns,
\item optionally adds a "Total percent" row (column mode only),
\item handles missing outcomes either as a separate "Response missing" row
or by excluding them, with or without a separate "Missing percent"
line, and
\item writes a corresponding unweighted N table including (or excluding)
missing responses.
}

A light formatting layer is applied using the \pkg{openxlsx} package:

\itemize{
\item table headers: bold, with top and bottom borders,
\item row labels: bold,
\item total rows ("Total percent" and "Column totals"): bold, with top and
bottom borders, and
\item missing-percentage row: italic.
}
}
\examples{
out_file <- tempfile(fileext = ".xlsx")

df <- data.frame(
  courteous = factor(c("Definitely true","Mostly true", NA, "Mostly false")),
  listener  = factor(c("Often","Sometimes","Never", NA)),
  sex       = factor(c("Male","Female","Female","Male")),
  agegrp1   = factor(c("18-34","35-54","18-34","55+")),
  weight = c(1, 1.5, 0.8, 1.2)
)

tabbit_excel(
  data         = df,
  vars         = c("courteous", "listener"),
  breakdown    = c("sex", "agegrp1"),
  file         = out_file,
  wtvar        = "weight",
  row_pct      = FALSE,
  decimals     = 1L,
  nooverall    = FALSE,
  nototal      = FALSE,
  missingasrow = FALSE,
  nomissing    = FALSE
)

}
