% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{get_width}
\alias{get_width}
\title{Extract width from  `LAS` object representing segmented tree.}
\usage{
get_width(las, quantiles = c(0.001, 0.999))
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
individually segmented tree}

\item{quantiles}{Z quantiles at which widths are measured
are measured. Values in the interval (0,1) are recommended to trim
random noise.}
}
\value{
A named numeric vector with elements `mean_width`, `x_width`,
and `y_width` (m).
}
\description{
Function to extract width from LAS object. Function calculates
difference between two specified quantiles from the `X` and `Y` attributes
and returns both widths and their average.
}
\examples{
library(lidR)
las = readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
las = clean_las(las)
print(get_width(las))
}
