% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_point_cloud.R
\name{get_lacunarity}
\alias{get_lacunarity}
\title{Calculate crown lacunarity from a tree crown}
\usage{
get_lacunarity(las, res = 0.1, angle = 0)
}
\arguments{
\item{las}{`LAS` object from `lidR` package representing
the CROWN of a tree. Crowns must be segmented using [segment_crown()].}

\item{res}{numeric - resolution of voxelization}

\item{angle}{numeric - in degrees, rotation angle about Z axis.}
}
\value{
A numeric value representing crown lacunarity (unitless).
}
\description{
This function calculates the lacunarity or "porosity" of a tree crown
by defined as 1 - the ratio of a voxelized crown hull and a convex hull.
See `voxel_hull_2D()` and `convex_hull_2D()`
}
\examples{
las = lidR::readLAS(system.file("extdata", "tree_0744.laz", package="tReeTraits"))
cbh = get_crown_base(las, threshold=0.25, sustain=2)
las = segment_crown(las, cbh)
get_crown_volume_voxel(las)
get_crown_volume_alpha(las)
sf::st_area(convex_hull_2D(las)) #profile area, convex hull
sf::st_area(voxel_hull_2D(las)) #profile area, voxel hull
get_lacunarity(las)
}
